<?php

namespace App\Http\Controllers;

use App\Models\Activity;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Choices;
use App\Models\Result;
use App\Models\Resultsdgs;
use App\Models\Project;
use App\Models\Project__Districts;
use App\Models\ActivityDistrict;
use App\Models\ActivitySDGIndicators;
use App\Models\SDGIndicators;
use App\Models\UserGroup;
use App\Models\DistrictGroupProjectUser;
use Response;
use DB;
use View;
use Auth;
use Gate;
class ActivityController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
      
        if (! Gate::allows('activity_access')) {
            return abort(401);
        }
       $sessiondata = session()->get('result_id');
        $project_id=$sessiondata->project_id;
        $result_id=$sessiondata->id;

      $activity=Activity::where('result_id',$result_id)->get();
      $check=DistrictGroupProjectUser::where('project_id',$project_id)->get();
       return view('activity.index',compact('activity','result_id','check'));
    
    }

public function setResultid($id)
{

        $results=Result::find($id);
        Session()->put('result_id',$results);
        Session()->save();
       return redirect()->route('activity.create');
}

public function setResultidCreate($id)
{

        $results=Result::find($id);
        Session()->put('result_id',$results);
        Session()->save();
       return redirect()->route('activity.create');
}


 

    public function getResult($project=0){

        // Fetch Project by ID
        $userData['data'] = Result::orderby("title","asc")
                    ->select('id','title')
                    ->where('project_id',$project)
                    ->get();
  
        echo json_encode($userData);
        
        exit;
    }

      public function getDistrict($project=0){

        // Fetch Project by ID
        $userData['data'] = Project__Districts::orderby("district","asc")
                    ->select('id','district')
                    ->where('project_id',$project)
                    ->get();
  
        echo json_encode($userData);
        
        exit;
    }
     

   public function treeView($results)
   {

         //dd($results);
         $userData= Resultsdgs::orderby("sdg","asc")
                     ->select('sdg')
                      ->where('result_id',$results)
                      ->get()->pluck('sdg');
               
              $userIndicator=SDGIndicators::with(['children'])->whereIn('id',$userData)->get();
             
            return response()->json($userIndicator);
               
       
   }
      public function editTreeView($id)
   {
           $act=Activity::find($id);
          // $sessiondata = session()->get('result_id');
           $result_id=$act->results->id;
          
           $userData= Resultsdgs::orderby("sdg","asc")
                     ->select('sdg')
                      ->where('result_id',$result_id)
                      ->get()->pluck('sdg');
                    
               
            $userIndicator=SDGIndicators::with(['children'])->whereIn('id',$userData)->get();
            $ActuserData= ActivitySDGIndicators::orderby("indicators","asc")
                     ->select('indicators')
                       ->where('activity_id',$id)
                       ->where('indicators','>',186)
                      ->get()->pluck('indicators');
            //$jsondata={'userData':$userData,'selectedIndicators':$ActuserData};
            return response()->json([$userIndicator,$ActuserData]);
               
       
   }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    { 
        if (! Gate::allows('activity_create')) {
            return abort(401);
        }
        $sessiondata = session()->get('result_id');
        //dd($sessiondata);
        $project_id=$sessiondata->project_id;
        $result_id=$sessiondata->id;
        $users=User::all('id','name');
        $activity_district=Project__Districts::where('project_id',$project_id)->get();
        $projects=Project::all('id','code');
        $status = Choices::where('type','Status')->orderBy('description', 'ASC')->get();
        $activity_types = Choices::where('type','Activity Type')->orderBy('description', 'ASC')->get();
        $sectors = Choices::where('type','Sector')->orderBy('description', 'ASC')->get();
        $responsible=UserGroup::where('project_id',$project_id)->get();
        //dd($data);
        return View::make('activity.create',compact('status','users','activity_types','sectors','projects','project_id','result_id','activity_district','responsible'));
   
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $lastValue=Activity::where('result_id',$request->result_id)->where('project_id',$request->project_id)->pluck('activity_no')->last();

       //dd($request);
         $act = new Activity();
            
            $act->project_id=$request->project_id;
            $act->status=$request->status;
            $act->title=$request->title;
            $act->budget=$request->budget;
            $act->activity_no=++$lastValue;
            $act->result_id=$request->result_id;
            $act->type=$request->type;
            $act->total_target=$request->total_target;
            $act->start_date=$request->start_date;
            $act->end_date=$request->end_date;
            $act->created_by=Auth::user()->id;
            $act->responsible=$request->responsible;
            $act->save();
            //  Other Table Saving
        $data =$request->dd;
        //dd($data);
        $data2 =$request->target;
       // dd($data,$data2);
        foreach($data as $index=>$d )
             {
                $pd = new ActivityDistrict();
                    $pd->activity_id=$act->id;
                    $pd->created_by=Auth::user()->id;
                    $pd->district=$d;
                    $pd->target=$data2[$index];
        
                      $pd->save();

            }
        $dataIndicator=$request->userIndicator;
       // dd($dataIndicator);
       $newVar=(explode(",",$dataIndicator[0]));
        //dd($newVar);
        foreach($newVar as $d )
             {

                $pact = new ActivitySDGIndicators();
                    $pact->activity_id=$act->id;
                    $pact->created_by=Auth::user()->id;
                    $pact->indicators=$d;
        
                      $pact->save();

            }

            return redirect()->route('result.index')->with('message','Activity Added');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Activity  $activity
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        if (! Gate::allows('activity_view')) {
            return abort(401);
        }
        $sessiondata = session()->get('result_id');
        $project_id=$sessiondata->project_id;
        $result_id=$sessiondata->id;
        $project=Project::find($project_id);
        $activity=Activity::find($id);
        $districts=ActivityDistrict::where('activity_id',$id)->get();
    
        $indicators=ActivitySDGIndicators::where('activity_id',$id)->where('indicators','>',186)->get();
       
       //dd($sdg);
        
        $projectdistrict=Project__Districts::where('project_id',$project_id)->get();
        
        return view('activity.show',compact('project','activity','districts','projectdistrict','indicators'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Activity  $activity
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

        if (! Gate::allows('activity_edit')) {
            return abort(401);
        }
        $activity=Activity::find($id);
        $sessiondata = session()->get('result_id');
        $project_id=$activity->results->project->id;
        $result_id=$activity->results->id;
        $activity_district=ActivityDistrict::where('activity_id',$id)->get();
        $users=User::all('id','name');
        $projects=Project::all('id','code');
        $status = Choices::where('type','Status')->orderBy('description', 'ASC')->get();
        $activity_types = Choices::where('type','Activity Type')->orderBy('description', 'ASC')->get();
        $sectors = Choices::where('type','Sector')->orderBy('description', 'ASC')->get();
        $responsible=UserGroup::where('project_id',$project_id)->get();
        $projectdistrict=Project__Districts::where('project_id',$project_id)->get(); 
           return view('activity.edit',compact('activity','project_id','result_id','projects','status','activity_types','activity_district','sectors','users','responsible','projectdistrict'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Activity  $activity
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request,  $id)
    {
         
            $act =  Activity::find($id);
            $act->project_id=$request->project_id;
            $act->status=$request->status;
            $act->title=$request->title;
            $act->budget=$request->budget;
            $act->activity_no=$request->activity_no;
            $act->result_id=$request->result_id;
            $act->type=$request->type;
            $act->total_target=$request->total_target;
            $act->start_date=$request->start_date;
            $act->end_date=$request->end_date;
            $act->created_by=Auth::user()->id;
            $act->responsible=$request->responsible;
            $act->save();
            //  Other Table Saving
       $acdist= ActivityDistrict::where('activity_id',$act->id);
        $acdist->delete();  
        $data =$request->dd;
        $data2 =$request->target;
        foreach($data as $index=>$district )
             {
                $pd = new ActivityDistrict();
                    $pd->activity_id=$act->id;
                    $pd->created_by=Auth::user()->id;
                    $pd->district=$district;
                    $pd->target=$data2[$index];
                    $pd->save();

            }

        $sdg=ActivitySDGIndicators::where('activity_id',$act->id);
         $sdg->delete(); 
        $dataIndicator=$request->userIndicator;
       // dd($dataIndicator);
       $newVar=(explode(",",$dataIndicator[0]));
        //dd($newVar);
        foreach($newVar as $d )
             {

                $pact = new ActivitySDGIndicators();
                    $pact->activity_id=$act->id;
                    $pact->created_by=Auth::user()->id;
                    $pact->indicators=$d;
        
                      $pact->save();

            }

            return redirect()->route('result.index')->with('message','Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Activity  $activity
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        if (! Gate::allows('activity_delete')) {
            return abort(401);
        }
        $act =Activity::find($id);
        $act->delete();
         $acd=ActivityDistrict::where('activity_id',$id);
         $acd->delete();
         $acsdgs=ActivitySDGIndicators::where('activity_id',$id);
         $acsdgs->delete();
        
        return redirect()->route('result.index')->with('message','Activity Deleted Successfully');
    }
}
