<?php

namespace App\Http\Controllers;

use App\Models\Choices;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use View;
use Auth;
class ChoicesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
         
        if (! Gate::allows('choices_access')) {
            return abort(401);
        }
         $choices = Choices::orderBy('updated_at')->get();

        return view('choices.index',compact('choices'));
    
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
    if (! Gate::allows('choices_create')) {
            return abort(401);
        }
        $parent=Choices::where('type','Parent')->get();
        $type=Choices::where('type','Parent')->get();
       
        return View::make('choices.create',compact('parent','type'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
       // dd($request);
         $this->validate($request,[
           'description'  => 'required',
           'type'=> 'required',
           'status'=>'required',
         ]);

          $choice = new Choices();
                    $choice->description=$request->description;
                    $choice->type=$request->type;
                    $choice->status=$request->status;
                    $choice->created_by=Auth::user()->id;
                    
                   
                    $choice->save();
                    return redirect()->route('choices.index')->with('message','Choice Added');

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Choices  $choices
     * @return \Illuminate\Http\Response
     */
    public function show(Choices $choices)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Choices  $choices
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        if (! Gate::allows('choices_edit')) {
            return abort(401);
        }
        $choice=Choices::find($id);
         $parent=Choices::where('type','Parent')->get();
        $type=Choices::where('type','Parent')->get();
        return view('choices.edit',compact('choice','parent','type'));
        
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Choices  $choices
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $choice=Choices::find($id);
         $choice->description=$request->description;
                    $choice->type=$request->type;
                    $choice->status=$request->status;
                   
        $choice->save();
         return redirect()->route('choices.index')->with('message','Choice Update');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Choices  $choices
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        if (! Gate::allows('choices_delete')) {
            return abort(401);
        }
        $choice =Choices::find($id);
        $choice->delete();
        return redirect()->route('choices.index')->with('message','Choice Deleted');
        
    }
}
