<?php

namespace App\Http\Controllers;

use App\Models\Demographics;
use Illuminate\Support\Facades\Gate;
use Illuminate\Http\Request;
use App\Models\Geographies;
use App\Models\Choices;
use View;
use Auth;
class DemographicsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
         if (! Gate::allows('demo_access')) {
            return abort(401);
        }
    $demo = Demographics::latest()->paginate(16);
    return view('demo.index',compact('demo'))->with('i', (request()->input('page', 1) - 1) * 5);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
          if (! Gate::allows('demo_create')) {
            return abort(401);
        }
        $geo=Geographies::all();
        $indicator_list = Choices::where('type','Demographics Indicators')->orderBy('description', 'ASC')->get();
        $source_list = Choices::where('type','Source')->orderBy('description', 'ASC')->get();
        return View::make('demo.create',compact('geo','indicator_list','source_list'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
       // dd($request);
       

          $demo = new Demographics();
                    $demo->value=$request->value;
                    $demo->source=$request->source;
                    $demo->indicator=$request->indicator;
                    $demo->geometry=$request->geometry;
                    $demo->geographies_id=$request->geographies_id;
                    $demo->created_by=Auth::user()->id;

                    $demo->save();


         return redirect()->route('demo.index')->with('message','Demographics Added');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Demographics  $demographics
     * @return \Illuminate\Http\Response
     */
    public function show(Demographics $demographics)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Demographics  $demographics
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
         if (! Gate::allows('demo_edit')) {
            return abort(401);
        }

         $demo= Demographics::find($id);
         //dd($demo);
         $geo=Geographies::all();
         $indicator_list = Choices::where('type','Demographics Indicators')->orderBy('description', 'ASC')->get();
        $source_list = Choices::where('type','Source')->orderBy('description', 'ASC')->get();
        return View::make('demo.edit',compact('demo','geo','indicator_list','source_list'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Demographics  $demographics
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request,  $id)
    {
        $demo=Demographics::find($id);
                    $demo->value=$request->value;
                    $demo->source=$request->source;
                    $demo->indicator=$request->indicator;
                    $demo->geometry=$request->geometry;
                    $demo->geographies_id=$request->geographies_id;
                    $demo->created_by=Auth::user()->id;

                    $demo->save();


         return redirect()->route('demo.index')->with('message','Demographics Updated');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Demographics  $demographics
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $demo=Demographics::find($id);
        $demo->delete();
        return redirect()->route('demo.index')->with('message','Demographics Deleted');
    }
}
