<?php

namespace App\Http\Controllers;

use App\Models\Geographies;
use Illuminate\Support\Facades\Gate;
use Illuminate\Http\Request;
use App\Models\User;
use Auth;
use View;
use DB;

class GeographiesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if (! Gate::allows('geo_access')) {
            return abort(401);
        }
        $geo = Geographies::all();
        return view('geo.index',compact('geo'));
    }
    public function create()
    {
       if (! Gate::allows('geo_create')) {
        return abort(401);
    }
    $geo=Geographies::all();
    return View::make('geo.create',compact('geo'));
}


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function addchild($id)
    {

    //dd($id);
       if (! Gate::allows('geo_create')) 
       {
        return abort(401);
        }
    $parent=$id; 
    $geo=Geographies::find($parent);
    $type=$geo->type;
    $globelType='';
    if($type=='Province')
    {
        $globelType='District';
    }
    elseif($type=='District')
    {
       $globelType='Tehsil';
   }
   elseif($type=='Tehsil')
   {
       $globelType='UC';
   }
   elseif($type=='UC')
   {
       $globelType='Village';
   }
   else{
    $globelType="";
}

return view('geo.addchild',compact('parent','globelType'));
}

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //dd($request);

      $geo = new Geographies();
      $geo->name=$request->name;
      $geo->type=$request->type;
      $geo->created_by=Auth::user()->id;
      $geo->parent=$request->parent;
      $geo->status=$request->status;
      $geo->geometry=$request->geometry;
      $geo->save();
      return redirect()->route('geo.index')->with('message','Geographies Added');

  }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Geographies  $geographies
     * @return \Illuminate\Http\Response
     */
    public function show(Geographies $geographies)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Geographies  $geographies
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
       if (! Gate::allows('geo_edit')) {
        return abort(401);
    }

    $geo= Geographies::find($id);
    $geoAll=Geographies::all();
    return View::make('geo.edit',compact('geo','geoAll'));
}

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Geographies  $geographies
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
      $geo=Geographies::find($id);
      $geo->name=$request->name;
      $geo->type=$request->type;
      $geo->parent=$request->parent;
      $geo->status=$request->status;
      $geo->geometry=$request->geometry;
      $geo->created_by=Auth::user()->id;
      $geo->save();


      return redirect()->route('geo.index')->with('message','Geographies Update');
  }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Geographies  $geographies
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
       if (! Gate::allows('geo_delete')) {
        return abort(401);
    }
    $geo=Geographies::find($id);
    $geo->delete();

    return redirect()->route('geo.index')->with('message','Geographies Deleted');
}
public function search(Request $request)
{
    $search=$request->get('search');
    $geo=DB::table('geographies')
    ->where('name','ilike','%'.$search.'%')
    ->orWhere('type','ilike','%'.$search.'%')
    ->orWhere('parent','ilike','%'.$search.'%')     
    ->paginate(16);
     //dd($geo);
    return view('geo.index',compact('geo'))->with('i', (request()->input('page', 1) - 1) * 15);  
}
}
