<?php

namespace App\Http\Controllers;

use App\Models\ProgressReport;
use Illuminate\Http\Request;
use App\Models\Project;
use App\Models\Result;
use App\Models\Activity;
use App\Models\ActivityDistrict;
use App\Models\User;
use App\Models\Choices;
use View;
use Auth;
class ProgressReportController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
    $reports = ProgressReport::latest()->paginate(16);
    return view('progress.index',compact('reports'))->with('i', (request()->input('page', 1) - 1) * 5);
    }



       public function getResult($project=0){

        // Fetch Project by ID
        $userData['data'] = Result::orderby("title","asc")
                    ->select('id','title')
                    ->where('project_id',$project)
                    ->get();
  
        echo json_encode($userData);
        
        exit;
    }

         public function getActivity($result=0){

        // Fetch Project by ID
        $userData['data'] = Activity::orderby("title","asc")
                    ->select('id','title','type')
                    ->where('result_id',$result)
                    ->get();
  
        echo json_encode($userData);
        
        exit;
    }
    public function getType($activity=0){

        // Fetch Project by ID
        $userData['data'] = Activity::
                    select('type')
                    ->where('id',$activity)
                    ->get();
  
        echo json_encode($userData);
        
        exit;
    }
    public function getGeography($activity=0){

        // Fetch Project by ID
        $userData['data'] = ActivityDistrict::orderby("district","asc")
                    ->select('id','district')
                    ->where('activity_id',$activity)
                    ->get();
  
        echo json_encode($userData);
        
        exit;
    }



    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $status = Choices::where('type','Status')->orderBy('description', 'ASC')->get();
        $reports=ProgressReport::all();
        $project=Project::all();
        $users=User::all();

        return View::make('progress.create',compact('reports','project','users','status'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
      // dd($r
    }

public function direction(Request $request)
{
      // dd($request);
       $project_id=$request->projects;
       $result_id=$request->results_id;
       $activity_id=$request->activity_id;
       $activity_type=$request->atypeName;
      if($activity_type=='Support')
    return redirect()->route('support.getValues',compact('activity_type','activity_id','project_id','result_id'));
    else if($activity_type=='Session')
        return redirect()->route('sessionevent.getValues',compact('activity_type','activity_id','project_id','result_id'));

}
    

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\ProgressReport  $progressReport
     * @return \Illuminate\Http\Response
     */
    public function show(ProgressReport $progressReport)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\ProgressReport  $progressReport
     * @return \Illuminate\Http\Response
     */
    public function edit(ProgressReport $progressReport)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\ProgressReport  $progressReport
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ProgressReport $progressReport)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\ProgressReport  $progressReport
     * @return \Illuminate\Http\Response
     */
    public function destroy(ProgressReport $progressReport)
    {
        //
    }
}
