<?php

namespace App\Http\Controllers;

use App\Models\Project;
use Illuminate\Support\Facades\Gate;
use Illuminate\Http\Request;
use App\Models\Result;
use App\Models\Activity;
use App\Models\ActivityDistrict;
use App\Models\Choices;
use App\Models\Stakeholders;
use App\Models\ResultSDG;
use App\Models\Geographies;
use App\Models\Benificiaries;
use App\Models\Project__Districts;
use App\Models\UserGroup;
use App\Models\DistrictGroupProjectUser;
use View;  
use Auth; 
use DB;    
class ProjectController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

       if (! Gate::allows('project_access')) {
        return abort(401);
    }

    $id=Auth::user()->id;
    $role=implode(',',Auth::user()->roles()->get()->pluck('name')->toArray());
    
 if($role=="Administrator")
    {
       $projects =Project::latest()->paginate(5);
      return view('project.index',compact('projects'))->with('i', (request()->input('page', 1) - 1) * 5);
   }
else{
    

  //  $projects=DB::select("select * from projects INNER JOIN(select DISTINCT * from (SELECT project_id FROM district_group_project_users where user_id='$id' UNION ALL select id from projects where created_by='$id') as sub ) as sub on sub.project_id=projects.id;");
  // // dd($projects);
         

  $subQuery = DB::table('district_group_project_users')
                    ->select('project_id')
                   ->where('user_id', $id)
                   ->union(Project::select('id')->where('created_by',$id))
                   ->distinct();
//dd($subQuery);
$projects = DB::table('projects')
                ->joinSub($subQuery,'subquery', function ($join) {
                 $join->on('projects.id', '=', 'subquery.project_id');
                 })->paginate(5);
    //dd($projects);

                // map to get json 
       
 
    return view('project.index',compact('projects'))->with('i', (request()->input('page', 1) - 1) * 5);
}



}

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
     if (! Gate::allows('project_create')) {
        return abort(401);
    }
    return View::make('project.create',self::getChoices());
}

    // Choices Function to Display the Lists for drop down list and others fields

public static function getChoices()

{
    $currency_list = Choices::where('type','Currency')->orderBy('description', 'ASC')->get();
    $reporting_list = Choices::where('type','Reporting Frequency')->orderBy('description', 'ASC')->get();
    $donor_list = Choices::where('type','Donor')->orderBy('description', 'ASC')->get();
    $sdg_list = Choices::where('type','SDG')->orderBy('description', 'ASC')->get();
    $sector_list = Choices::where('type','Sector')->orderBy('description', 'ASC')->get();
    $district_list = Geographies::where('type','District')->orderBy('name', 'ASC')->get();
    $unit_list =Choices::where('type','Unit')->orderBy('description', 'ASC')->get();
    $responsible_list=Choices::where('type','Responsible')->orderBy('description', 'ASC')->get();
    $stackholders_list =Choices::where('type','Stakeholder')->orderBy('description', 'ASC')->get();
    $userGroup_list =Choices::where('type','UserGroup')->orderBy('description', 'ASC')->get();
    $benif = Choices::where('type','Beneificiaries')->orderBy('id', 'ASC')->get();                    
    $status=Choices::where('type','Status')->orderBy('description','ASC')->get();

    return ['stackholders_list'=>$stackholders_list,'responsible_list'=>$responsible_list,'unit_list'=>$unit_list,'sector_list'=>$sector_list,'district_list'=>$district_list,'sdg_list'=>$sdg_list,'currency_list'=>$currency_list,'reporting_list'=>$reporting_list,'donor_list'=>$donor_list,'benif'=>$benif,'userGroup_list'=>$userGroup_list,'status'=>$status];
}


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $project = new Project();
        $userid=Auth::user()->id;
        $project->title = $request->title;
        $project->code = $request->code;
        $project->created_by = $userid;
        $project->end_date = $request->end_date;
        $project->start_date = $request->start_date;
        $project->currency = $request->currency;
        $project->status = $request->status;
        $project->budget = $request->budget;
        $project->objectives = $request->objectives;
        $project->specificobjectives = $request->specificobjectives;
        $project->abreviation = $request->abreviation;
        $project->pcr_deadline = $request->pcr_deadline;
        $project->donor = $request->donor;
        $project->donor_fp_name = $request->donor_fp_name;
        $project->donor_fp_email = $request->donor_fp_email;
        $project->donor_fp_designation = $request->donor_fp_designation;
        $project->donor_fp_mobile = $request->donor_fp_mobile;
        $project->donor_fp_phone_office = $request->donor_fp_phone_office;
        $project->brsp_fp_email = $request->brsp_fp_email;
        $project->brsp_fp_name = $request->brsp_fp_name;
        $project->brsp_fp_designation = $request->brsp_fp_designation;
        $project->brsp_fp_mobile = $request->brsp_fp_mobile;
        $project->brsp_fp_phone_office = $request->brsp_fp_phone_office;
        $project->reporting_frequency = $request->reporting_frequency;
            // save Project

        $project->save();

            //  Other Table Saving
        $stackeholders=$request->get('project_stackholders');
        if($stackeholders)
            foreach($request->get('project_stackholders') as $stackeholder)
            {
                $project_stackholder = new Stakeholders([
                    'project_id'=> $project->id,
                    'name'=>$stackeholder
                ]);
                $project_stackholder->save();
            }
            
            $pd=$request->get('project_districts');
            //dd($pd);
            if($pd)
                foreach($request->get('project_districts') as $pd)
                {
                    $pd = new Project__Districts([
                        'project_id'=> $project->id,
                        'district'=>$pd
                    ]);
                    $pd->save();
                }  
            // USerGroup

                $pug=$request->get('usergroup');
                if($pug)
                    foreach($request->get('usergroup') as $pug)
                    {
                        $pug = new UserGroup([
                            'project_id'=> $project->id,
                            'name'=>$pug
                        ]);
                        $pug->save();
                    }  
             //Benificiries
                    $data =$request->indicator;
                    $data2 =$request->values;
                    
               //dd($data,$data2);
                    foreach($data as $index=>$d )
                    {
                        $pb = new Benificiaries();
                        $pb->project_id=$project->id;
                        $pb->created_by=Auth::user()->id;
                        $pb->indicator=$d;
                        $pb->values=$data2[$index];
                        $projects=$request->project_id;
                        $pb->save();

                    }

                    return redirect()->route('project.index')->with('message','Project Added');
                }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Project  $project
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
      if (! Gate::allows('project_view')) {
        return abort(401);
    }

    $project=Project::find($id);
    //dd($project);
    return View::make('project.show',compact('project'),self::getChoices());
}

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Project  $project
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        if (! Gate::allows('project_edit')) {
            return abort(401);
        }
        $project= Project::find($id);
        return View::make('project.edit',compact('project'),self::getChoices());
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Project  $project
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request,  $id)
    {
        //dd($request);

        $project=Project::find($id);
        
        $userid=Auth::user()->id;
        $project->title = $request->title;
        $project->code = $request->code;
        $project->created_by = $userid;
        $project->end_date = $request->end_date;
        $project->start_date = $request->start_date;
        $project->currency = $request->currency;
        $project->status = $request->status;
        $project->budget = $request->budget;
        $project->objectives = $request->objectives;
        $project->specificobjectives = $request->specificobjectives;
        $project->abreviation = $request->abreviation;
        $project->pcr_deadline = $request->pcr_deadline;
        $project->donor = $request->donor;
        $project->donor_fp_name = $request->donor_fp_name;
        $project->donor_fp_email = $request->donor_fp_email;
        $project->donor_fp_designation = $request->donor_fp_designation;
        $project->donor_fp_mobile = $request->donor_fp_mobile;
        $project->donor_fp_phone_office = $request->donor_fp_phone_office;
        $project->brsp_fp_email = $request->brsp_fp_email;
        $project->brsp_fp_name = $request->brsp_fp_name;
        $project->brsp_fp_designation = $request->brsp_fp_designation;
        $project->brsp_fp_mobile = $request->brsp_fp_mobile;
        $project->brsp_fp_phone_office = $request->brsp_fp_phone_office;
        $project->reporting_frequency = $request->reporting_frequency;
            // save Project
        $project->save();

        Project__Districts::where('project_id', $project->id)->delete();

        $pd=$request->get('project_districts');
        if($pd)
            foreach($request->get('project_districts') as $pd)
            {
                $pd = new Project__Districts([
                    'project_id'=> $project->id,
                    'district'=>$pd
                ]);
                $pd->save();
            }  
            // Stackholders
            Stakeholders::where('project_id', $project->id)->delete();
            $stackeholders=$request->get('project_stackholders');
            if($stackeholders)
                foreach($request->get('project_stackholders') as $stackeholder)
                {
                    $project_stackholder = new Stakeholders([
                        'project_id'=> $project->id,
                        'name'=>$stackeholder
                    ]);
                    $project_stackholder->save();
                }

            // USerGroup
                UserGroup::where('project_id', $project->id)->delete();
                $userG=$request->get('usergroup');
                if($userG)
                    foreach($request->get('usergroup') as $userG)
                    {
                        $userG = new UserGroup([
                            'project_id'=> $project->id,
                            'name'=>$userG
                        ]);
                        $userG->save();
                    }

             //Benificiries
                    Benificiaries::where('project_id', $project->id)->delete();
                    $data =$request->indicator;
                    $data2 =$request->values;
        //dd($data,$data2);
                    foreach($data as $index=>$d )
                    {
                        $pb = new Benificiaries();
                        $pb->project_id=$project->id;
                        $pb->created_by=Auth::user()->id;
                        $pb->indicator=$d;
                        $pb->values=$data2[$index];
                        $projects=$request->project_id;
                        $pb->save();

                    }
                    return redirect()->route('project.index')->with('success','Project Updated Successfully');
                }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Project  $project
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        if (! Gate::allows('project_delete')) {
            return abort(401);
        }
       // dd($project->id);
        $project =Project::find($id);
        $pd=Project__Districts::where('project_id',$id);
        $ps=Stakeholders::where('project_id',$id);
        $pb=Benificiaries::where('project_id',$id);
        $pr=Result::where('project_id',$id);
        $pa=Activity::where('project_id',$id);
        $pug=UserGroup::where('project_id',$id);
        //dd($pr);
        
        $project->delete();
        $pd->delete();
        $ps->delete();
        $pb->delete();
        $pr->delete();
        $pa->delete();
        $pug->delete();
        return redirect()->route('project.index')->with('message','Project Deleted Successfully');

    }

    public function psearch(Request $request)
{
    $search=$request->get('search');
    $projects=DB::table('projects')
    ->where('title','ilike','%'.$search.'%')
    ->orWhere('donor','ilike','%'.$search.'%')
    ->orWhere('code','ilike','%'.$search.'%')
    ->orWhere('currency','ilike','%'.$search.'%') 
    ->orWhere('budget','ilike','%'.$search.'%')     
    ->paginate(5);
    
    return view('project.index',compact('projects'))->with('i', (request()->input('page', 1) - 1) * 4);  
}

}
