<?php

namespace App\Http\Controllers;

use App\Models\Result;
use App\Models\Resultsdgs;
use Illuminate\Http\Request;
use App\Models\Choices;
use App\Models\Project;
use App\Models\User;
use App\Models\SDGIndicators;
use App\Models\ActivityDistrict;
use App\Models\ActivitySDGIndicators;
use App\Models\UserGroup;
use App\Models\Activity;
use View;
use Auth;
use DB;
use Session;
use Gate;

class ResultController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()

    {
          if (! Gate::allows('result_access')) {
            return abort(401);
        }
       $project_id = session()->get('project_id');
       $project=Project::find($project_id);
        //dd($project);
       $results = Result::where('project_id',$project_id)->get();
       $user_id=Auth::user()->id;
       //dd($user_id);
       $users=DB::table('district_group_project_users')->where('user_id',$user_id)->where('project_id',$project_id)->get();
     
       //dd($users);
        return view('result.index',compact('results','users','project'));
    }

 public function getProject($id)
    { 
        
        $projects=Project::find($id);
        Session()->put('project_id',$id);
        Session()->save();
       return redirect()->route('result.index');
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {    if (! Gate::allows('result_create')) {
            return abort(401);
        }
        $users=User::all('id','name');
        $projects = session()->get('project_id');
        $sdgs = SDGIndicators::where('type','SDG')->orderBy('id', 'ASC')->get();
        $status = Choices::where('type','Status')->orderBy('description', 'ASC')->get();
      
        
         
        return View::make('result.create',compact('projects','status','users','sdgs'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        
        //dd($request);
          $this->validate($request,[
           'project_id'=> 'required',
           'title'=> 'required',
         ]);

          $lastValue=Result::where('project_id',$request->project_id)->pluck('result_no')->last();
         //dd($lastValue);
          $res = new Result();
                    $res->project_id=$request->project_id;
                    $res->created_by=Auth::user()->id;
                    $res->title=$request->title;
                    $res->result_no=++$lastValue;
                    $res->save();

        $sdgs=$request->get('sdg');
        if($sdgs)
        foreach($request->get('sdg') as $sdgs)
            {
                $sdg = new Resultsdgs([
                    'result_id'=> $res->id,
                    'created_by'=>Auth::user()->id,
                    'sdg'=>$sdgs
                ]);
                $sdg->save();
            }
     return redirect()->route('result.index')->with('message','Result Added');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Result  $result
     * @return \Illuminate\Http\Response
     */
    public function show(Result $result)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Result  $result
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
          if (! Gate::allows('result_edit')) {
            return abort(401);
        }
        $result= Result::find($id);
        $users=User::all('id','name');
        $projects = session()->get('project_id');
        $sdgs = SDGIndicators::where('type','SDG')->orderBy('id', 'ASC')->get();
        $status = Choices::where('type','Status')->orderBy('description', 'ASC')->get();
        
        return View::make('result.edit',compact('projects','result','sdgs','status','users'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Result  $result
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
         $this->validate($request,[
           'project_id'=> 'required',
           'title'=> 'required',
         ]);
        
    
          $res = Result::find($id);

         
                    $res->project_id=$request->project_id;
                    $res->created_by=Auth::user()->id;
                    $res->title=$request->title;
                    $res->result_no=$request->result_no;
                    $res->save();
       
        Resultsdgs::where('result_id',$res->id)->delete();
        $sdgs=$request->get('sdg');
        if($sdgs)
        foreach($request->get('sdg') as $sdgs)
            {
                $sdg = new Resultsdgs([
                    'result_id'=> $res->id,
                    'created_by'=>Auth::user()->id,
                    'sdg'=>$sdgs
                ]);
                $sdg->save();
            }
     
            
     return redirect()->route('result.index')->with('message','Result Updated');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Result  $result
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
          if (! Gate::allows('result_delete')) {
            return abort(401);
        }
        $res =Result::find($id);
        $result_sdgs=Resultsdgs::where('result_id',$id);
        $pactivity=Activity::where('result_id',$id);
         $pactivity->delete();
        $res->delete();
        $result_sdgs->delete();
        return redirect()->route('result.index')->with('message','Project Result Deleted Successfully');
    }

public function  reorder_result(Request $request)
    { 
       
        $results=$request->results;
       dd($results);
        if($results)
        {
        $index=1;
        foreach($results as $r)
            {
                $r = Result::find($r);
                $r->result_no=$index++;
                $r->save();
            }
        }
        return redirect()->route('result.index');
    }

}
