<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Gate;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Role;
use App\Models\Permission;

use DB;
use View;
class RoleController extends Controller
{
  
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if (! Gate::allows('role_access')) {
            return abort(401);
        }

        $roles = Role::orderBy('id','DESC')->paginate(5);
        return view('roles.index',compact('roles'))
            ->with('i', ($request->input('page', 1) - 1) * 5);
    }
    
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        
        // if (! Gate::allows('role_create')) {
        //     return abort(401);
        // }
      
        
        $types=Permission::select('type')->distinct()->get();
        $entities=Permission::select('type','entity')->orderBy('entity','ASC')->distinct()->get();
        $permission=Permission::select('id','name','entity')->orderBy('name','ASC')->get();
      
        return view('roles.create',compact('permission','entities','types'));
    }
    
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //dd($request);
        $this->validate($request, [
            'name' => 'required|unique:roles,name',
            'permission'=>'required'
         
        ]);
    
        $role = Role::create(['name' => $request->input('name')]);
       // $role->syncPermissions($request->input('permission'));
        $role->permission()->attach($request->permission);
        return redirect()->route('roles.index')
                        ->with('success','Role created successfully');
    }
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        // $role = Role::find($id);
        // // $rolePermissions = Permission::join("role_has_permissions","role_has_permissions.permission_id","=","permissions.id")
        // //     ->where("role_has_permissions.role_id",$id)
        // //     ->get();
    
        // return view('roles.show',compact('role','rolePermissions'));
    }
    
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        
        if (! Gate::allows('role_edit')) {
            return abort(401);
        }

        $role = Role::find($id);
        $types=Permission::select('type')->distinct()->get();
        $entities=Permission::select('type','entity')->orderBy('entity','ASC')->distinct()->get();
        $permission=Permission::select('id','name','entity')->orderBy('name','ASC')->get();
       
        $per_role=DB::table('permission_role')->where('role_id',$id)->get();

    
        return view('roles.edit',compact('role','permission','per_role','permission','entities','types'));
    }
    
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
            
        ]);
    
        $role = Role::find($id);
        $role->name = $request->input('name');
        $role->permission()->sync($request->permission);
        $role->save();
    
        // $role->syncPermissions($request->input('permission'));
    
        return redirect()->route('roles.index')
                        ->with('success','Role updated successfully');
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
       
        if (! Gate::allows('role_delete')) {
            return abort(401);
        }
       $role=Role::where('id',$id);
       $permission_role=DB::table('permission_role')->where('role_id',$id);
       $role->delete();
       $permission_role->delete();
       
        return redirect()->route('roles.index')
                        ->with('success','Role deleted successfully');
    }
}