<?php

namespace App\Http\Controllers;

use App\Models\SessionEvent;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\DistrictGroupProjectUser;
use App\Models\Project__Districts;
use App\Models\Activity;
use App\Models\ActivityDistrict;
use Session;
use View;
use Auth;
use DB;
class SessionEventController extends Controller
{
   /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
   
    }

public function getValues(Request $request)
   {

    // dd($request);
    //Request Data pass to variable
    $activity_id=$request->activity_id;
    $activity_type=$request->activity_type;
    $project_id=$request->project_id;
    $result_id=$request->result_id;
    //Session Put 
    Session()->put('activity_id',$activity_id);
    Session()->put('activity_type',$activity_type);
    Session()->put('project_id',$project_id);
    Session()->put('result_id',$result_id);
    Session()->save();
    //get ID of the Current User
    $id=Auth::id();
    //Global Variable 
    $district='0';
    $ugroup='0';
    // Data from DistrictGroupProjectUser Table 
    $users=DistrictGroupProjectUser::where('user_id',$id)->get();
  //To get User District & UserGroup
    foreach($users as $user)
    {
        $district=$user->district_id;
        $ugroup=$user->group_id;
    }
 
 
    $total=Activity::where('id',$activity_id)->value('total_target');
    $dt=ActivityDistrict::where('activity_id',$activity_id)->where('district',$district)->value('target');
    $totalAchivedM=SessionEvent::where('activity_id',$activity_id)->sum('male');
    $totalAchivedF=SessionEvent::where('activity_id',$activity_id)->sum('female');
    $totalAchived=$totalAchivedF+$totalAchivedM;
    $data = SessionEvent::where('activity_id',$activity_id)->get();
    $male = DB::table('session_events')->where('activity_id','=',$activity_id)->where('district',$district)->sum('male');
    $female = DB::table('session_events')->where('activity_id','=',$activity_id)->where('district',$district)->sum('female');
    $achivedtarget=$male+$female;
    
   return view('sessionevent.index',compact('data','project_id','result_id','activity_type','users','activity_id','total','dt','achivedtarget','totalAchived','ugroup'));

   }
 
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        
        $activity_id=session()->get('activity_id');
        $project_id=session()->get('project_id');

        $district=Project__Districts::where('project_id',$project_id)->get();

        return View::make('sessionevent.create',compact('activity_id','district'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //dd($request);
          $this->validate($request,[
           'activity_id'=>'required',
           'district'=>'required',
           'male'=> 'required',
           'female'=>'required',
           'remarks'=>'required',
         ]);

          $res = new SessionEvent();
                    $res->activity_id=$request->activity_id;
                    $res->created_by=Auth::user()->id;
                    $res->male=$request->male;
                    $res->district=$request->district;
                    $res->female=$request->female;
                    $res->remarks=$request->remarks;
                    $res->save();

    $activity_id=session()->get('activity_id');
    $activity_type=session()->get('activity_type');
    $project_id=session()->get('project_id');
    $result_id=session()->get('result_id');
    //dd($result_id);
     return redirect()->route('sessionevent.getValues',compact('activity_type','activity_id','project_id','result_id'));
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Session  $session
     * @return \Illuminate\Http\Response
     */
    public function show(Session $session)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Session  $session
     * @return \Illuminate\Http\Response
     */
    public function edit(Session $session)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Session  $session
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Session $session)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Session  $session
     * @return \Illuminate\Http\Response
     */
    public function destroy(Session $session)
    {
        //
    }
}
