<?php

namespace App\Http\Controllers;

use App\Models\Support;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\DistrictGroupProjectUser;
use App\Models\Activity;
use App\Models\ActivityDistrict;
use App\Models\Project__Districts;
use Session;
use Auth;
use View;
class SupportController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
      
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
   public function getValues(Request $request)
   {

    // dd($request);
    //Request Data pass to variable
    $activity_id=$request->activity_id;
    $activity_type=$request->activity_type;
    $project_id=$request->project_id;
    $result_id=$request->result_id;
    //Session Put 
    Session()->put('activity_id',$activity_id);
    Session()->put('activity_type',$activity_type);
    Session()->put('project_id',$project_id);
    Session()->put('result_id',$result_id);
    Session()->save();
    //get ID of the Current User
    $id=Auth::id();
    //Global Variable 
    $district='0';
    $ugroup='0';
    // Data from DistrictGroupProjectUser Table 
    $users=DistrictGroupProjectUser::where('user_id',$id)->get();
  //To get User District & UserGroup
    foreach($users as $user)
    {
        $district=$user->district_id;
        $ugroup=$user->group_id;
    }
 
 
    $total=Activity::where('id',$activity_id)->value('total_target');
    $dt=ActivityDistrict::where('activity_id',$activity_id)->where('district',$district)->value('target');
    //$totalAchivedM=SessionEvent::where('activity_id',$activity_id)->sum('male');
    //$totalAchivedF=SessionEvent::where('activity_id',$activity_id)->sum('female');
   //$totalAchived=$totalAchivedF+$totalAchivedM;
    $data = Support::where('activity_id',$activity_id)->get();
   // $male = DB::table('session_events')->where('activity_id','=',$activity_id)->where('district',$district)->sum('male');
    //$female = DB::table('session_events')->where('activity_id','=',$activity_id)->where('district',$district)->sum('female');
    //$achivedtarget=$male+$female;
    
   return view('support.index',compact('data','project_id','result_id','activity_type','users','activity_id','dt','ugroup','total'));

   }
    public function create()
    {
        
        $activity_id=session()->get('activity_id');
        $project_id=session()->get('project_id');
        $users=User::all();
        $district=Project__Districts::where('project_id',$project_id)->get();
        return View::make('support.create',compact('activity_id','district','users'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //dd($request);
         $this->validate($request,[
           'description'  => 'required',
           'identified_by'=> 'required',
           'mode_of_transfer'=>'required',
           'amount'=>'required',
           'district'=>'required',
         ]);
         $support = new Support();
                    $support->activity_id=$request->activity_id;
                    $support->created_by=Auth::user()->id;
                    $support->district=$request->district;
                    $support->person_id=$request->person_id;
                    $support->identification_date=$request->identification_date;
                    $support->support_date=$request->support_date;
                    $support->support_type=$request->support_type;
                    $support->support_type_sub_category=$request->support_type_sub_category;
                    $support->identified_by=$request->identified_by;
                    $support->amount=$request->amount;
                    $support->facilitated_by=$request->facilitated_by;
                    $support->mode_of_transfer=$request->mode_of_transfer;
                    $support->description=$request->description;
        $support->save();
    return redirect()->route('support.getValues')->with('message','Progress Report Added');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Support  $support
     * @return \Illuminate\Http\Response
     */
    public function show(Support $support)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Support  $support
     * @return \Illuminate\Http\Response
     */
    public function edit(Support $support)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Support  $support
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Support $support)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Support  $support
     * @return \Illuminate\Http\Response
     */
    public function destroy(Support $support)
    {
        //
    }
}
