<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use DB;
use Hash;
use Auth;   
use App\Models\Choices;
use App\Models\User;
use App\Models\Role;
use App\Models\Project;
use App\Models\UserGroup;
use App\Models\Project__Districts;
use App\Models\DistrictGroupProjectUser;
class UserController extends Controller
{
 

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if (! Gate::allows('user_access')) {
            return abort(401);
        }
        $users = User::latest()->paginate(6);
        return view('users.index',compact('users'))
            ->with('i', ($request->input('page', 1) - 1) * 5);
    }

    public function getUserGroup($id)
    {
         $userData['data'] = UserGroup::orderby("name","asc")
                    ->select('id','name')
                    ->where('project_id',$id)
                    ->get();
  
        echo json_encode($userData);
        
        exit;
    }
       public function getDistrict($id)
    {
         $userData['data'] = Project__Districts::orderby("district","asc")
                    ->select('id','district')
                    ->where('project_id',$id)
                    ->get();
  
        echo json_encode($userData);
        
        exit;
    }
    
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        if (! Gate::allows('user_create')) {
            return abort(401);
        }
        $projects=Project::all();
        $roles = Role::all();
        $dep=Choices::where('type','Departement')->orderBy('description', 'ASC')->get();
        $des=Choices::where('type','Designation')->orderBy('description', 'ASC')->get();
        return view('users.create',compact('roles','projects','dep','des'));
    }
    
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //dd($request);
        $this->validate($request, [
            'name' => 'required',
            'email' => 'required|email|unique:users,email',
            'password' => 'required|same:password_confirmation',
            'departement'=>'required',
            'designation'=>'required',
            'empcode'=>'required',
            'roles'=>'required'

        ]);
         
          $user = new User();
                    $user->name=$request->name;
                    $user->email=$request->email;
                    $user->password=Hash::make($request->password);
                    $user->empcode=$request->empcode;
                    $user->departement=$request->departement;
                    $user->designation=$request->designation;
                    $user->save();
                    $user->roles()->sync($request->roles);
        return redirect()->route('users.index')
                        ->with('success','User created successfully');
    }
    
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {

        if (! Gate::allows('user_access')) {
            return abort(401);
        }
        $user = User::find($id);
        return view('users.show',compact('user'));
    }
    
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
         $user = User::find($id);
         $roles=Role::all();
         $dep=Choices::where('type','Departement')->orderBy('description', 'ASC')->get();
         $des=Choices::where('type','Designation')->orderBy('description', 'ASC')->get();
         return view('users.edit',compact('user','roles','des','dep'));
    }
    
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request,  $id)
    {
        
         $name=$request->name;
         $email=$request->email;
         $password=Hash::make($request->password);
         $designation=$request->designation;
         $departement=$request->departement;
         $empcode=$request->empcode;
         $array=['name'=>$name,'email'=>$email,'password'=>$password,'departement'=>$departement,'designation'=>$designation,'empcode'=>$empcode];
         $user=User::find($id);  
         $user->update($array);
         $user->roles()->sync($request->roles);
         return redirect()->route('users.index')
                         ->with('success','User updated successfully');
    }
    
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //dd($id);

        if (! Gate::allows('user_delete')) {
            return abort(401);
        }
        $user=User::find($id);
        $user->delete();
        return redirect()->route('users.index')
                        ->with('success','User deleted successfully');
    }

    public function manage($id)
    {
        $user=User::find($id);
        $projects=Project::all();
        $roles=Role::all();
        return view('users\manage',compact('user','projects','roles'));
    }

    public function saveOtherUser(Request $request)
    {
       // dd($request);
         $this->validate($request, [
            'user_id' => 'required',
            'project'=>'required',
            'usergroup'=>'required',
            'district'=>'required'
        ]);

         $userDetails=New DistrictGroupProjectUser();
         $userDetails->user_id=$request->user_id;
         $userDetails->group_id=$request->usergroup;
         $userDetails->district_id=$request->district;
         $userDetails->project_id=$request->project;
         $userDetails->save();

         $id=$request->user_id;
         
        return redirect()->route('users.userdetails',compact('id'))
                        ->with('success','Add Other successfully');     
    }
     public function userDetails($id)
    {
      
        if (! Gate::allows('user_create')) {
            return abort(401);
        }
       $user=User::find($id);
       //dd($user);
       $data=DistrictGroupProjectUser::where('user_id',$id)->get();
      // dd($data);
        return view('users.userdetails',compact('data','user'));
    }

    public function managedelete($id)
    {
        
        if (! Gate::allows('user_delete')) {
            return abort(401);
        }
        $user_id=DistrictGroupProjectUser::where('id',$id)->select('user_id')->get();

        $user=DistrictGroupProjectUser::find($id);
        $user->delete();
        return redirect()->route('users.index',compact('user_id'))
                        ->with('success','User Access deleted successfully');
    }
public function saveupassword(Request $request)
{
   $this->validate($request, [
            
            'password' => 'required|same:password_confirmation'

        ]);
         $id=$request->id;
         $password=Hash::make($request->password);
         $array=['password'=>$password];
         $user=User::find($id); 
         //dd($user);
         $user->update($array);
         return redirect()->route('login')->with(Auth::logout());


}
public function upassword()
{
    $id=Auth::user()->id;
    $user=User::find($id);
 return view('users.upassword',compact('user'));
}


}
