<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\Uuids;
class Activity extends Model
{
    use HasFactory,Uuids;

    protected $guarded=[];

   // protected $dates=['start_date','end_date'];
    // Belongs to
     public function results()
    {
        return $this->belongsTo(Result::class,'result_id');
    }
     public function user()
    {
        return $this->belongsTo(User::class,'created_by');
    }
   public function usergroup()
    {
        return $this->belongsTo(UserGroup::class,'responsible');
    }


    // Has Many RelationShip 

    public function activitesdistricts()
    {
        
        return $this->hasMany(ActivityDistrict::class);
    }

    public function indicators()
    {
        
        return $this->hasMany(SDGIndicators::class);
    }
    public function activitesindicators()
    {
        
        return $this->hasMany(ActivitySDGIndicators::class);
    }

    public function report()
    {
        
        return $this->hasMany(ProgressReport::class);
    }
     public function support()
    {
        
        return $this->hasMany(Support::class);
    }
      public function session()
    {
        
        return $this->hasMany(SessionEvent::class);
    }
}
