<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\Uuids;

class ProgressReport extends Model
{
    use HasFactory,Uuids;

protected $fillable=['id','activity_id','created_by','reported_by','reported_by_other','reported_by_other_designation','geography_id','status','activity_date','location','remarks','institution','qauntity'];

  public function user()
    {
        return $this->belongsTo(User::class,'created_by');
    }

      public function activity()
    {
        return $this->belongsTo(Activity::class,'activity_id');
    }
      public function activityDistrict()
    {
        return $this->belongsTo(ActivityDistrict::class,'geography_id');
    }
}
