<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Benificiaries;
use App\Models\Project__District;
use App\Models\Result;
use App\Models\Stakeholders;
use App\Models\UserGroup;
use App\Traits\Uuids;

class Project extends Model
{
    use HasFactory,Uuids;
    protected $guarded = [];
    // Date Formate
  
    
// Relationship


public function results()
    {
        return $this->hasMany(Result::class)->orderBy('result_no');
    }
    public function beneificiaries()
    {
        
        return $this->hasMany(Benificiaries::class);
    }
     public function stackholders()
    {
        
        return $this->hasMany(Stakeholders::class);
    }
    public function userGroup()
    {
        
        return $this->hasMany(UserGroup::class);
    }
    public function projectdistrict()
    {
        
        return $this->hasMany(Project__Districts::class);
    }


  public function project()
    {
        return $this->belongsToMany(User::class,'project_user');
    }
    public function manytomany()
    {
        
        return $this->hasMany(DistrictGroupProjectUser::class,'project_id');
    }
}
