<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\Uuids;
class  Project__Districts extends Model
{
    use HasFactory,Uuids;
     protected $fillable=['id','project_id','district','created_by'];
    
    public function project()
    {
        return $this->belongsTo(Project::class,'project_id');
    }
      public function user_district()
    {
      return $this->belongsToMany(User::class,'district_users','user_id','district_id');
    }
    public function sessionevent()
    {
      return $this->belongsTo(SessionEvent::class);
    }
    public function manytomany()
    {
        
        return $this->hasMany(DistrictGroupProjectUser::class);
    }
     public function geographies()
    {
        return $this->belongsTo(Geographies::class,'district');
    }
}
