<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\Uuids;
class Result extends Model
{
    use HasFactory,Uuids;
    // Mass Assigment 
    protected $fillable=['id','project_id','created_by','title','result_no'];

 public function user()
    {
        return $this->belongsTo(User::class,'created_by');
    }
      public function project()
    {
        return $this->belongsTo(Project::class,'project_id');
    }
  public function users()
    {
        return $this->belongsTo(User::class,'created_by');
    }
    

// has Many Relationship
    public function resultsdgs()
    {
        
        return $this->hasMany(Resultsdgs::class);
    }

    public function activities()
    {
        
        return $this->hasMany(Activity::class);
    }
}

