<?php

namespace App\Models;


use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use App\Traits\Uuids;
use App\Models\Project__Districts;
use App\Models\UserGroup;


class User extends Authenticatable
{
    use HasFactory, Notifiable,Uuids;

  
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'departement',
        'designation',
        'empcode',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

 public function roles()
    {
        return $this->belongsToMany(Role::class,'users_role');
    }
     
    
     public function manytomany()
    {
        
        return $this->hasMany(DistrictGroupProjectUser::class,'user_id');
    }
 public function geo()
    {
        
        return $this->hasMany(Geographies::class);
    }
     public function choices()
    {
        
        return $this->hasMany(Choices::class);
    }
}
