<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\Uuids;
use App\Models\User;
use App\Models\Activity;
class UserGroup extends Model
{
    use HasFactory,Uuids;
     protected $fillable = [
        'project_id',
        'name'
    ];

    
    public function project()
    {
        return $this->belongsTo(Project::class);
    }
     public function user_usergroup()
    {
       return $this->belongsToMany(User::class,'user_usergroup','user_id','group_id');
    }
    public function activity()
    {
        return $this->hasMany(Activity::class,'id');
    }
     public function manytomany()
    {
        
        return $this->hasMany(DistrictGroupProjectUser::class);
    }
}